/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime;

import filenet.vw.api.VWCompoundStepDefinition;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.api.VWStepHistory;
import filenet.vw.api.VWStepOccurrenceHistory;
import filenet.vw.api.VWStepProcessorInfo;
import filenet.vw.api.VWWorkObject;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.VWTrkDataModel;
import filenet.vw.toolkit.runtime.VWTrkMap;
import filenet.vw.toolkit.runtime.VWTrkRoute;
import filenet.vw.toolkit.runtime.VWTrkStepOccurrence;
import filenet.vw.toolkit.runtime.VWTrkStepOccurrenceHistory;
import filenet.vw.toolkit.runtime.VWTrkWorkObject;
import filenet.vw.toolkit.runtime.images.VWImageLoader;
import filenet.vw.toolkit.utils.VWInstruction;
import filenet.vw.toolkit.utils.VWStepUtils;
import filenet.vw.toolkit.utils.wfdefinition.VWDefaultSessionProxy;
import java.util.Date;
import java.util.Vector;
import javax.swing.ImageIcon;

public class VWTrkStep {
    VWTrkDataModel m_dataModel = null;
    VWTrkMap m_map = null;
    private static VWStepProcessorInfo[] m_stepProcessors = null;
    private static VWStepProcessorInfo[] m_launchStepProcessors = null;
    int m_mapId = -1;
    int m_stepId = -1;
    String m_stepName = null;
    VWMapNode m_mapNode = null;
    VWStepDefinition m_stepDefinition = null;
    VWCompoundStepDefinition m_compoundStepDefinition = null;
    VWTrkMap m_mapCalled = null;
    VWStepProcessorInfo m_stepProcessor = null;
    Vector<VWTrkStepOccurrence> m_occurrences = null;
    Vector<VWTrkRoute> m_prevRoutes = new Vector();
    Vector<VWTrkRoute> m_nextRoutes = new Vector();
    int m_selectedOccurrenceIndex = -1;

    public VWTrkStep(VWTrkMap map, VWMapNode mapNode) {
        this.m_map = map;
        if (map != null) {
            this.m_dataModel = map.getDataModel();
            this.m_mapId = map.getMapId();
        }
        this.m_mapNode = mapNode;
        if (mapNode != null) {
            if (mapNode instanceof VWStepDefinition) {
                this.m_stepDefinition = (VWStepDefinition)mapNode;
            }
            if (mapNode instanceof VWCompoundStepDefinition) {
                this.m_compoundStepDefinition = (VWCompoundStepDefinition)mapNode;
                try {
                    VWInstructionDefinition[] instructions = this.m_compoundStepDefinition.getInstructions();
                    if (instructions != null) {
                        for (int i = 0; i < instructions.length; ++i) {
                            if (instructions[i].getAction() != 5) continue;
                            String mapName = VWInstruction.CallInstructionGetSubmap(instructions[i]);
                            this.m_mapCalled = this.m_dataModel.getMap(mapName);
                            if (this.m_mapCalled == null) continue;
                            this.m_mapCalled.addCallingStep(this);
                        }
                    }
                }
                catch (VWException vWException) {
                    // empty catch block
                }
            }
            this.m_stepId = mapNode.getStepId();
            this.m_stepName = mapNode.getName();
        }
        this.getStepProcessorNames();
    }

    public void getStepProcessorNames() {
        try {
            if (VWDefaultSessionProxy.isLoggedOn()) {
                if (m_stepProcessors == null) {
                    m_stepProcessors = VWDefaultSessionProxy.fetchStepProcessors(10);
                }
                if (m_launchStepProcessors == null) {
                    m_launchStepProcessors = VWDefaultSessionProxy.fetchStepProcessors(5);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public VWStepProcessorInfo getStepProcessor() {
        try {
            if (this.m_stepProcessor == null) {
                this.m_stepProcessor = VWDefaultSessionProxy.fetchStepProcessorInfo(this.m_stepDefinition.getRequestedInterface());
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return this.m_stepProcessor;
    }

    public VWTrkDataModel getDataModel() {
        return this.m_dataModel;
    }

    VWFieldDefinition getFieldDefinition(String name) {
        if (this.m_dataModel != null) {
            return this.m_dataModel.getFieldDefinition(name);
        }
        return null;
    }

    public Vector getStepOccurrenceHistory() {
        if (this.m_occurrences == null || this.m_occurrences.size() == 0) {
            return null;
        }
        Vector<VWTrkStepOccurrenceHistory> history = new Vector<VWTrkStepOccurrenceHistory>();
        for (int i = 0; i < this.m_occurrences.size(); ++i) {
            VWTrkStepOccurrenceHistory stepOccurrenceHistory;
            VWTrkStepOccurrence occurrence = this.m_occurrences.elementAt(i);
            if (occurrence == null || (stepOccurrenceHistory = occurrence.getStepOccurrenceHistory()) == null) continue;
            history.addElement(stepOccurrenceHistory);
        }
        if (history.size() == 0) {
            return null;
        }
        return history;
    }

    public void addPreviousRoute(VWTrkRoute route) {
        this.m_prevRoutes.addElement(route);
    }

    public void addNextRoute(VWTrkRoute route) {
        this.m_nextRoutes.addElement(route);
    }

    public Vector getPreviousRoutes() {
        return this.m_prevRoutes;
    }

    public Vector getNextRoutes() {
        return this.m_nextRoutes;
    }

    public void addStepOccurrenceHistory(VWStepOccurrenceHistory stepOccurrenceHistory) {
        VWTrkStepOccurrence stepOccurrence = null;
        try {
            stepOccurrence = this.m_dataModel.is41Workflow() ? this.getStepOccurrence(stepOccurrenceHistory.getDateReceived()) : this.getStepOccurrenceFromId(stepOccurrenceHistory.getOccurrenceId());
        }
        catch (VWException ex) {
            stepOccurrence = null;
        }
        if (stepOccurrence != null) {
            stepOccurrence.updateStepOccurrenceHistory(stepOccurrenceHistory);
        } else {
            if (this.m_occurrences == null) {
                this.m_occurrences = new Vector();
            }
            this.m_occurrences.addElement(new VWTrkStepOccurrence(this, stepOccurrenceHistory, this.m_stepId, this.m_occurrences.size()));
        }
    }

    public void addStepHistory(VWStepHistory stepHistory) {
        if (stepHistory == null) {
            return;
        }
        try {
            VWStepOccurrenceHistory stepOccurrenceHistory;
            while (stepHistory.hasNext() && (stepOccurrenceHistory = stepHistory.next()) != null) {
                this.addStepOccurrenceHistory(stepOccurrenceHistory);
            }
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
        }
    }

    public void addStepOccurrenceHistory(VWTrkStepOccurrenceHistory stepHistroy) {
        if (stepHistroy == null) {
            return;
        }
        VWTrkStepOccurrence stepOccurrence = null;
        if (this.m_dataModel.is41Workflow()) {
            Date dateReceived = stepHistroy.getDateReceived();
            if (dateReceived != null) {
                stepOccurrence = this.getStepOccurrence(dateReceived);
            }
        } else {
            int occurrenceId = stepHistroy.getOccurrenceId();
            stepOccurrence = this.getStepOccurrenceFromId(occurrenceId);
        }
        if (stepOccurrence != null) {
            stepOccurrence.updateStepOccurrenceHistory(stepHistroy);
        } else {
            if (this.m_occurrences == null) {
                this.m_occurrences = new Vector();
            }
            this.m_occurrences.addElement(new VWTrkStepOccurrence(this, stepHistroy, this.m_stepId, this.m_occurrences.size()));
        }
    }

    public void addWorkObject(VWTrkWorkObject workObject) {
        VWTrkStepOccurrence stepOccurrence;
        block14: {
            int occurrenceId;
            if (workObject == null) {
                return;
            }
            stepOccurrence = null;
            if (this.m_dataModel.is41Workflow()) {
                stepOccurrence = this.getLastOccurrence();
            } else {
                try {
                    VWWorkObject vwWob = workObject.getVWWorkObject();
                    if (vwWob == null) {
                        return;
                    }
                    occurrenceId = VWTrkWorkObject.getOccurrenceId(vwWob);
                    if (occurrenceId != -1) {
                        stepOccurrence = this.findOccurrence(occurrenceId);
                    }
                }
                catch (VWException ex) {
                    // empty catch block
                }
            }
            if (stepOccurrence == null) {
                try {
                    VWTrkStepOccurrenceHistory stepOccurrenceHistory = new VWTrkStepOccurrenceHistory(this.m_stepId, workObject);
                    this.addStepOccurrenceHistory(stepOccurrenceHistory);
                    try {
                        if (this.m_dataModel.is41Workflow()) {
                            stepOccurrence = this.getStepOccurrence(workObject.getDateReceived());
                            break block14;
                        }
                        occurrenceId = workObject.getOccurrenceId();
                        stepOccurrence = this.getStepOccurrenceFromId(occurrenceId);
                    }
                    catch (VWException ex) {}
                }
                catch (VWException ex) {
                    VWDebug.logException(ex);
                }
            }
        }
        if (stepOccurrence != null) {
            stepOccurrence.addWorkObject(workObject);
        }
    }

    public VWMapNode getMapNode() {
        return this.m_mapNode;
    }

    public VWStepDefinition getStepDefinition() {
        return this.m_stepDefinition;
    }

    public VWCompoundStepDefinition getCompoundStepDefinition() {
        return this.m_compoundStepDefinition;
    }

    public Vector getOccurrenceCollection() {
        if (this.m_occurrences != null && this.m_occurrences.size() > 0) {
            return this.m_occurrences;
        }
        return null;
    }

    public int getOccurrenceCount() {
        if (this.m_occurrences != null) {
            return this.m_occurrences.size();
        }
        return 0;
    }

    public VWTrkStepOccurrence getStepOccurrenceFromId(int occurrenceId) {
        VWTrkStepOccurrence stepOccurrence = null;
        if (this.m_occurrences != null && occurrenceId != -1) {
            for (int i = 0; i < this.m_occurrences.size(); ++i) {
                try {
                    int oid;
                    stepOccurrence = this.m_occurrences.elementAt(i);
                    if (stepOccurrence != null && (oid = stepOccurrence.getOccurrenceId()) != -1 && oid == occurrenceId) {
                        return stepOccurrence;
                    }
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public VWTrkStepOccurrence getStepOccurrence(Date timeStamp) {
        if (this.m_occurrences != null && timeStamp != null) {
            Date dateReceived = null;
            for (int i = 0; i < this.m_occurrences.size(); ++i) {
                try {
                    VWTrkStepOccurrence stepOccurrence = this.m_occurrences.elementAt(i);
                    if (stepOccurrence != null && (dateReceived = stepOccurrence.getDateReceived()) != null && timeStamp.equals(dateReceived)) {
                        return stepOccurrence;
                    }
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public VWTrkStepOccurrence getStepOccurrence(int index) {
        if (this.m_occurrences == null) {
            return null;
        }
        if (index < this.m_occurrences.size()) {
            return this.m_occurrences.elementAt(index);
        }
        return null;
    }

    public String getStepName() {
        return this.m_stepName;
    }

    protected VWTrkMap getMap() {
        return this.m_map;
    }

    public int getMapId() {
        return this.m_mapId;
    }

    public int getStepId() {
        return this.m_stepId;
    }

    public String getOperationName() {
        if (this.m_stepDefinition != null) {
            return this.m_stepDefinition.getOperationName();
        }
        return null;
    }

    public int getStatus() {
        int status = 0;
        Vector activeOccurrences = this.getActiveOccurrences();
        if (activeOccurrences != null && activeOccurrences.size() > 0) {
            int occurrenceStatus = 0;
            block13: for (int i = 0; i < activeOccurrences.size(); ++i) {
                VWTrkStepOccurrence occurrence = (VWTrkStepOccurrence)activeOccurrences.elementAt(i);
                if (occurrence == null) continue;
                occurrenceStatus = occurrence.getStatus();
                switch (occurrenceStatus) {
                    case 1: {
                        status |= 1;
                        continue block13;
                    }
                    case 10: {
                        status |= 2;
                        continue block13;
                    }
                    case 9: {
                        status |= 4;
                    }
                }
            }
            if ((status & 4) != 0) {
                return 9;
            }
            if ((status & 2) != 0) {
                return 10;
            }
            if ((status & 1) != 0) {
                return 1;
            }
        }
        if (this.m_occurrences != null && this.m_occurrences.size() > 0) {
            status = 0;
            block14: for (int i = 0; i < this.m_occurrences.size(); ++i) {
                VWTrkStepOccurrence occurrence = this.m_occurrences.elementAt(i);
                if (occurrence == null || occurrence.isActive()) continue;
                int occurrenceStatus = occurrence.getStatus();
                switch (occurrenceStatus) {
                    case 4: {
                        status |= 1;
                        continue block14;
                    }
                    case 2: {
                        status |= 2;
                        continue block14;
                    }
                    case 1: {
                        status |= 4;
                        continue block14;
                    }
                    case 12: {
                        status |= 8;
                        continue block14;
                    }
                    case 13: {
                        status |= 0x10;
                        continue block14;
                    }
                    case 11: {
                        status |= 0x20;
                    }
                }
            }
            if ((status & 0x20) != 0) {
                return 11;
            }
            if ((status & 0x10) != 0) {
                return 13;
            }
            if ((status & 8) != 0) {
                return 12;
            }
            if ((status & 4) != 0) {
                return 1;
            }
            if ((status & 2) != 0) {
                return 2;
            }
            if ((status & 1) != 0) {
                return 4;
            }
        }
        return status;
    }

    public ImageIcon getStatusIcon() {
        return VWImageLoader.createStatusIcon(this.getStatus());
    }

    public VWTrkStepOccurrence getLastOccurrence() {
        int index;
        if (this.m_occurrences != null && this.m_occurrences.size() > 0 && (index = this.m_occurrences.size() - 1) >= 0) {
            return this.m_occurrences.elementAt(index);
        }
        return null;
    }

    public Vector getParticipantHistory() {
        Vector history = new Vector();
        if (this.m_occurrences == null) {
            return new Vector();
        }
        for (int i = 0; i < this.m_occurrences.size(); ++i) {
            Vector participantHistory = this.m_occurrences.elementAt(i).getParticipantHistory();
            if (participantHistory == null) continue;
            for (int j = 0; j < participantHistory.size(); ++j) {
                history.addElement(participantHistory.elementAt(j));
            }
        }
        return history;
    }

    public VWTrkStepOccurrence findOccurrence(int occurrenceId) {
        if (this.m_occurrences == null) {
            return null;
        }
        VWTrkStepOccurrence occurrence = null;
        for (int i = 0; i < this.m_occurrences.size(); ++i) {
            occurrence = this.m_occurrences.elementAt(i);
            if (occurrence == null || occurrence.getOccurrenceId() != occurrenceId) continue;
            return occurrence;
        }
        return null;
    }

    public VWTrkStepOccurrence findOccurrence(VWWorkObject wob) {
        if (this.m_occurrences == null || wob == null) {
            return null;
        }
        try {
            if (this.m_dataModel.is41Workflow()) {
                return this.getStepOccurrence(wob.getDateReceived());
            }
            return this.findOccurrence(VWTrkWorkObject.getOccurrenceId(wob));
        }
        catch (VWException ex) {
            return null;
        }
    }

    public Vector getActiveOccurrences() {
        if (this.m_occurrences == null) {
            return null;
        }
        Vector<VWTrkStepOccurrence> occurrences = new Vector<VWTrkStepOccurrence>();
        VWTrkStepOccurrence occurrence = null;
        for (int i = 0; i < this.m_occurrences.size(); ++i) {
            occurrence = this.m_occurrences.elementAt(i);
            if (!occurrence.isActive()) continue;
            occurrences.addElement(occurrence);
        }
        return occurrences;
    }

    public boolean isActive() {
        if (this.m_occurrences == null) {
            return false;
        }
        for (int i = 0; i < this.m_occurrences.size(); ++i) {
            VWTrkStepOccurrence occurrence = this.m_occurrences.elementAt(i);
            if (!occurrence.isActive()) continue;
            return true;
        }
        return false;
    }

    public boolean isAltered() {
        if (this.m_occurrences == null) {
            return false;
        }
        for (int i = 0; i < this.m_occurrences.size(); ++i) {
            VWTrkStepOccurrence occurrence = this.m_occurrences.elementAt(i);
            if (!occurrence.isAltered()) continue;
            return true;
        }
        return false;
    }

    public boolean isDummyStep() {
        if (this.m_mapNode == null) {
            return false;
        }
        int stepType = VWStepUtils.getStepType(this.m_mapNode);
        return stepType == 5 || stepType == 6;
    }

    public boolean isQueueStep() {
        if (this.m_mapNode == null) {
            return false;
        }
        int stepType = VWStepUtils.getStepType(this.m_mapNode);
        return stepType == 4 || stepType == 3;
    }

    public boolean isUserStep() {
        if (this.m_mapNode == null) {
            return false;
        }
        int stepType = VWStepUtils.getStepType(this.m_mapNode);
        return stepType == 2 || stepType == 1;
    }

    public boolean isCallStep() {
        if (this.m_mapNode == null) {
            return false;
        }
        int stepType = VWStepUtils.getStepType(this.m_mapNode);
        return stepType == 10 || stepType == 9;
    }

    public boolean isSystemStep() {
        if (this.m_mapNode == null) {
            return false;
        }
        int stepType = VWStepUtils.getStepType(this.m_mapNode);
        return stepType == 12 || stepType == 11;
    }

    public boolean isComponentStep() {
        if (this.m_mapNode == null) {
            return false;
        }
        int stepType = VWStepUtils.getStepType(this.m_mapNode);
        return stepType == 14 || stepType == 13;
    }

    public boolean isStartStep() {
        if (this.m_mapNode == null) {
            return false;
        }
        int stepType = VWStepUtils.getStepType(this.m_mapNode);
        return stepType == 10 || stepType == 6 || stepType == 8 || stepType == 4 || stepType == 12 || stepType == 2;
    }

    public boolean isLaunchStep() {
        return false;
    }

    public String getQueueName() {
        return this.m_stepDefinition.getQueueName();
    }

    public int getLockedStatus() {
        int status = 0;
        Vector activeOccurrences = this.getActiveOccurrences();
        if (activeOccurrences != null) {
            for (int i = 0; i < activeOccurrences.size(); ++i) {
                VWTrkStepOccurrence occurrence = (VWTrkStepOccurrence)activeOccurrences.elementAt(i);
                status |= occurrence.getLockedStatus();
            }
        }
        return status;
    }

    public boolean lockStep() {
        boolean bLocked = true;
        Vector occurrences = this.getActiveOccurrences();
        if (occurrences != null) {
            for (int i = 0; i < occurrences.size(); ++i) {
                Object obj = occurrences.elementAt(i);
                if (obj == null || !(obj instanceof VWTrkStepOccurrence)) continue;
                bLocked &= ((VWTrkStepOccurrence)obj).lockStepOccurrence();
            }
        }
        return bLocked;
    }

    public boolean unlockStep(boolean bSave, boolean bDispatch) {
        boolean bUnlocked = true;
        Vector occurrences = this.getActiveOccurrences();
        if (occurrences != null) {
            for (int i = 0; i < occurrences.size(); ++i) {
                Object obj = occurrences.elementAt(i);
                if (obj == null || !(obj instanceof VWTrkStepOccurrence)) continue;
                bUnlocked &= ((VWTrkStepOccurrence)obj).unlockStepOccurrence(bSave, bDispatch);
            }
        }
        return bUnlocked;
    }

    public ImageIcon getLockedStatusIcon() {
        return VWImageLoader.createLockIcon(this.getLockedStatus());
    }

    public int getSelectedOccurrenceIndex() {
        if (this.m_selectedOccurrenceIndex == -1) {
            this.m_selectedOccurrenceIndex = this.getOccurrenceCount() - 1;
        }
        return this.m_selectedOccurrenceIndex;
    }

    public void setSelectedOccurrenceIndex(int index) {
        this.m_selectedOccurrenceIndex = index >= this.getOccurrenceCount() ? this.getOccurrenceCount() - 1 : index;
    }

    void setInitialOccurrenceIndex(int index) {
        if (this.m_selectedOccurrenceIndex == -1) {
            this.m_selectedOccurrenceIndex = index;
        }
    }

    public VWTrkStepOccurrence getSelectedOccurrence() {
        int index = this.getSelectedOccurrenceIndex();
        if (this.m_occurrences != null && index >= 0 && index < this.m_occurrences.size()) {
            return this.m_occurrences.elementAt(index);
        }
        return null;
    }

    void removeAllWorkObjects(boolean bSave) {
        if (this.m_occurrences == null || this.m_occurrences.size() == 0) {
            return;
        }
        for (int i = 0; i < this.m_occurrences.size(); ++i) {
            VWTrkStepOccurrence occurrence = this.m_occurrences.elementAt(i);
            if (occurrence == null) continue;
            occurrence.removeAllWorkObjects(bSave);
        }
    }

    void removeHistory() {
        if (this.m_occurrences != null) {
            for (int i = 0; i < this.m_occurrences.size(); ++i) {
                VWTrkStepOccurrence obj = this.m_occurrences.elementAt(i);
                if (obj == null || !(obj instanceof VWTrkStepOccurrence)) continue;
                obj.removeReferences();
            }
            this.m_occurrences.removeAllElements();
            this.m_occurrences = null;
        }
    }

    void save() throws VWException {
        if (this.m_occurrences == null || this.m_occurrences.size() == 0) {
            return;
        }
        VWException exception = null;
        for (int i = 0; i < this.m_occurrences.size(); ++i) {
            VWTrkStepOccurrence occurrence = this.m_occurrences.elementAt(i);
            if (occurrence == null) continue;
            try {
                occurrence.save();
                continue;
            }
            catch (VWException ex) {
                if (exception != null) continue;
                exception = ex;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    void disgardChanges() {
        if (this.m_occurrences == null || this.m_occurrences.size() == 0) {
            return;
        }
        for (int i = 0; i < this.m_occurrences.size(); ++i) {
            VWTrkStepOccurrence occurrence = this.m_occurrences.elementAt(i);
            if (occurrence == null) continue;
            occurrence.disgardChanges();
        }
    }

    void refreshStep(boolean save) {
        if (this.m_dataModel != null) {
            Vector<VWTrkStep> v = new Vector<VWTrkStep>();
            v.addElement(this);
            this.m_dataModel.refresh(v, save);
        }
    }

    public boolean getCanReassign() {
        if (this.m_stepDefinition != null) {
            return this.m_stepDefinition.getCanReassign();
        }
        return false;
    }

    public void removeReferences() {
        Object obj;
        int i;
        this.m_dataModel = null;
        this.m_map = null;
        this.m_mapNode = null;
        this.m_stepDefinition = null;
        this.m_compoundStepDefinition = null;
        this.m_mapCalled = null;
        this.m_stepProcessor = null;
        if (this.m_occurrences != null) {
            for (i = 0; i < this.m_occurrences.size(); ++i) {
                obj = this.m_occurrences.elementAt(i);
                if (obj == null || !(obj instanceof VWTrkStepOccurrence)) continue;
                ((VWTrkStepOccurrence)obj).removeReferences();
            }
            this.m_occurrences.removeAllElements();
            this.m_occurrences = null;
        }
        if (this.m_prevRoutes != null) {
            for (i = 0; i < this.m_prevRoutes.size(); ++i) {
                obj = this.m_prevRoutes.elementAt(i);
                if (obj == null || !(obj instanceof VWTrkRoute)) continue;
                ((VWTrkRoute)obj).removeReferences();
            }
            this.m_prevRoutes.removeAllElements();
            this.m_prevRoutes = null;
        }
        if (this.m_nextRoutes != null) {
            for (i = 0; i < this.m_nextRoutes.size(); ++i) {
                obj = this.m_nextRoutes.elementAt(i);
                if (obj == null || !(obj instanceof VWTrkRoute)) continue;
                ((VWTrkRoute)obj).removeReferences();
            }
            this.m_nextRoutes.removeAllElements();
            this.m_nextRoutes = null;
        }
    }
}

